-----------------------------------------------------------------------------------------------
-- address_error_detail.sql
--
-- Show all addresses with errors in the Application address table (CLN_ADDRESSES)
--
-- History:
--   12/2/2006 Created
--
-- Copyright (c) 2005-2007 Runner Technologies, Inc.  All Rights Reserved.
-- www.RunnerTechnologies.com   sales@RunnerTechnologies.com   877-784-0003  561-395-9322
-----------------------------------------------------------------------------------------------
-- Customer has the right to modify this script so long as original copyright remains
-----------------------------------------------------------------------------------------------

select ca.Address_Error_Code "Err"
      ,CLEAN_Address_APP.Get_Error_Text(ca.Address_Error_Code) "Error_Desc"
      ,a.address_line_1 "Line1"
      ,a.address_line_2 "Line2"
      ,a.address_line_3 "Line3"
      ,a.address_line_4 "Line4"
      ,a.city     "City"
      ,a.state    "St"
      ,a.Postal_CODE "Zip"
      ,a.COUNTY_NAME   "County"
      ,a.ADDRESS_ID "Pkey"
      ,ca.address_verified_date "Verified"
from   CLN_ADDRESS_APP ca
      ,CLN_ADDRESSES a
where  a.Address_id = ca.ID_NUMBER(+)
and    NVL(a.ADDRESS_TYPE_CODE,'x') = NVL(ca.ADDRESS_TYPE(+), 'x')
and    a.UPDATED_DATE = ca.EFFECTIVE_DATE(+)
and    ca.FROM_TABLE(+) = 'CLN_ADDRESSES'
and    ca.address_error_code IS NOT NULL
--and a.UPDATED_DATE > sysdate - 180               -- ONLY RECORDS IN THE PAST 180 DAYS
--and rownum < 60000                        -- LIMIT TO 60,000 SO RESULTS WILL FIT IN EXCEL
--order by ca.Address_Error_Code;         -- UNCOMMENT FOR RANDOM ERROR CODES IN RESULTS

